'use client';

import { usePathname } from "next/navigation";
import { lazy, Suspense, useEffect } from "react";
import TopBar from "@/components/TopBar";
import LogoBar from "@/components/LogoBar";
import Header from "@/components/Header";
import SEOHead from "@/components/SEOHead";
import FirebaseProvider from "@/components/FirebaseProvider";

// Lazy load heavy components for better performance
const Footer = lazy(() => import("@/components/Footer"));
const FloatingButtons = lazy(() => import("@/components/FloatingButtons"));
const VisitorTracker = lazy(() => import("@/components/VisitorTracker"));

export default function LayoutWrapper({ children }: { children: React.ReactNode }) {
  const pathname = usePathname();
  const isAdmin = pathname?.startsWith('/admin');

  // Scroll to top on route change
  useEffect(() => {
    if (typeof window !== 'undefined') {
      window.scrollTo({ top: 0, left: 0, behavior: 'instant' });
    }
  }, [pathname]);

  if (isAdmin) {
    return (
      <FirebaseProvider>
        {children}
      </FirebaseProvider>
    );
  }

  return (
    <FirebaseProvider>
      <SEOHead />
      <Suspense fallback={null}>
        <VisitorTracker />
      </Suspense>
      <div className="w-full overflow-x-hidden max-w-full">
        <TopBar />
        <LogoBar />
        <Header />
        <main className="flex-grow w-full max-w-full overflow-x-hidden">{children}</main>
        <Suspense fallback={null}>
          <Footer />
        </Suspense>
        <Suspense fallback={null}>
          <FloatingButtons />
        </Suspense>
      </div>
    </FirebaseProvider>
  );
}

